libname q 'c:\SASCodeForBook\SASDataSets';

data first; set q.harfordschools;
	if Scnum = 11 then delete;
	if testyear = 2002 then delete;
	if testyear = 2001 then delete;
	period = testyear;
	run;

data second; set first;

                 /*These are the design variables*/

*cnvsmach =  conect = 1, matched no conect = 0 , not matched no conect = missing dot;

group3 = . ;
if cnvsmach = 1 then group3= 1;
if cnvsmach = 0 then group3= 3;
if cnvsmach = . then group3= 2;

Trt = Group3;

* Note:  the above code refers all comparisons to the matched group!;

group2 = .;
if cnvsmach = 1 then group2= 1;
Else group2 = 0;
* Note:  the above code refers all comparisons to the non co-nect groups;

                /*This code creates the year indicator variables */

year97 = . ;
if testyear = 1997 then year97 = 1;
else year97=0;

year98 = . ;
if testyear = 1998 then year98 = 1;
else year98=0;

year99 = . ;
if testyear = 1999 then year99 = 1;
else year99 = 0;

year20 = .;
if testyear = 2000 then year20 = 1;
else year20 = 0;

year21 = .;
if testyear = 2001 then year21 = 1;
else year21 = 0;

year22 = .;
if testyear = 2002 then year22 = 1;
else year22 = 0;


*This code groups all non conect together and creates indicator variable;

cnvsall = . ;
if cnvsmach = . or cnvsmach = 0 then cnvsall = 0;
if cnvsmach = 1 then cnvsall = 1;

* This code breaks up the groups for detailed assessment;
conect=. ;
if group3 = 1 then conect=1;
else conect = 0;

nomatch =. ;
if group3 = 2 then nomatch = 1;
else nomatch = 0;

match =.;
if group3 = 3 then match = 1;
else match = 0;

conect98 = conect*year98;
conect99 = conect*year99;
conect20 = conect*year20;
conect21 = conect*year21;
conect22 = conect*year22;

nomat98 = nomatch*year98;
nomat99 = nomatch*year99;
nomat20 = nomatch*year20;
nomat21 = nomatch*year21;
nomat22 = nomatch*year22;

ryear20 = .;
if year20 = 1 then ryear20 = 0; *post time period;
if year20 = 0 then ryear20 = 1; *base periods;
Post = 	ryear20;

                     /*These variables are properties of the school*/

*This code creates indicator variables for lowest grade of school, KG is one, preKG is zero;

If substr (Low_Grade,1,12)=  'Kindergarten' then lowstgrd = 1;
If substr (Low_Grade,1,15)=  'Prekindergarten' then lowstgrd = 0;

*This code creates indicator variable for location, urban fringe is one rural is zero;
locate = .;

If substr (locale,1,26) = 'Urban Fringe of Large City' then locate =1;
else locate = 0;

*This code creates indicator variable for targeted title1 school, one is yes it is,zero is no;
*No Conect schools are Title1 schools;

TargetT1 = . ;
if substr (title1sc,1,2) = 'No' then TargetT1 = 0;
if substr (title1sc,1,3) = 'Yes' then TargetT1 = 1;


*This code creates targeted poverty under SAFE;
Safe = . ;
if scnum = 2 or scnum = 4 or scnum = 6 or scnum = 7 or scnum = 8 or scnum = 20
or scnum = 29 then safe = 1; Else safe = 0;

lowecon = . ;
if safe = 1 and targett1 = 1 then lowecon = 2;
else if safe = 0 and targett1 = 0 then lowecon = 0;
else lowecon = 1;

    		 /*These Codes refer to the composition of the school*/

*This creates a gender variable, female to male ratio;
Femvmal = female/male;
femprob = female/studentt;

*These codes create proportions for ethnicity;
Nativep = Native_A/studentt;
Asianp  = Asian/studentt;
Blackp  = Black/studentt;
Hispanp = Hispanic/studentt;
Whitep  = White/studentt;


                /*this code creates a simple weight by implementation variable*/

impscore = 1 ;
if scnum= 6 then do;
        impscore = 1.52;
        end;
if scnum = 7 then do;
        impscore = 1.56;
                end;
if scnum = 17 then do;
        impscore = 1.8;
        end;
if scnum = 25 then do;
        impscore = 1.79;
        end;
if scnum = 31 then do;
        impscore = 1.86;
        end;

run;

       /* This code standardizes the variables by their means*/
proc standard data = second out= standard mean=0;
	var lowstgrd locate targett1 stratio femprob blackp forredlp safe year98 year99;
	weight impscore;
run;
proc means data= standard;
	var lowstgrd locate targett1 stratio femprob blackp forredlp safe
        year98 year99 year20 post msapperform avecomp gr3comp gr3read gr3math
        gr5comp gr5read gr5math;
	weight impscore;
run;


				/* Data for Table 11.4*/

/*To replicate these tables Proc Standard should be weighting the data by Impscore*/
Title 'Model 1 of Table 11.4, No Period on Repeated Statement, unstructured, No KR';
	proc mixed data=standard covtest ratio ic cl ;
	class  trt period school post;
	model msapperform = Trt Post Trt*Post year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp / s cl;
	Repeated /sub= school(trt) type = un r rcorr ;
	weight impscore;
	parms /nobound;
run;


Title 'Model 2 of Table 11.4, Period on Repeated Statement, Independent errors model, No KR';
proc mixed data=standard covtest ratio ic ;
	class  trt post period school;
	model msapperform = Trt Post Trt*Post  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/  s cl ;
	Repeated Period /sub= school(trt) type = vc r rcorr ;
	weight impscore;
	parms /nobound;
run;


Title 'Model 3 of Table 11.4, Period on Repeated Statement, UN(1)= Banded, No KR';
	proc mixed data=standard covtest ratio ic ;
	class  trt post period school;
	model msapperform = Trt Post Trt*Post  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/  s cl ;
	Repeated Period  /sub= school(trt) type = UN(1) r rcorr ;
	weight impscore;
	parms /nobound;
run;


Title 'Model 4 of Table 11.4, Period on Repeated Statement, CSH = Heterogeneous CS, No KR ';
	proc mixed data=standard covtest ratio ic ;
	class  trt post period school;
	model msapperform = Trt Post Trt*Post  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/  s cl ;
	Repeated Period /sub= school(trt) type = csh r rcorr ;
	weight impscore;
	*parms /nobound;
run;

/* Use the -2LL of the following model = 775.3 in the Null Model Likelihood Ratio test
for Model 4.  Its -2LL = 745.4. The difference of 29.9 with 4 degrees of freedom 
is very statistically significant p<.0001.  This regression model does not fit*/

Title 'Model 4a for Model 4, Table 11.4, No Repeated Statement, Regression Model, No KR ';
	proc mixed data=standard covtest ratio ic ;
	class  trt post period school;
	model msapperform = Trt Post Trt*Post  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/  s cl ;
	*Repeated Period /sub= school(trt) type = csh r rcorr ;
	weight impscore;
run;

Title 'Model 5 of Table 11.4, Period on Repeated Statement, CS= Compound Symetry, No KR';
	proc mixed data=standard covtest ratio ic ;
	class  trt post period school post;
	model msapperform = Trt Post Trt*Post  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/  s cl ;
	Repeated Period /sub= school(trt)type=cs r rcorr ;
	weight impscore;
	parms /nobound;
run;



Title'Model 6 of Table 11.4, random intercept with schools(trt)as subject, VC structured as CS, no KR';
	proc mixed data=standard covtest ratio ic ;
	class  school trt post period;
	model msapperform = trt post trt*post year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/  s  cl ;
	random intercept/ subject = school(trt) type = vc  s cl ;
	weight impscore;
	parms/nobound;
run;


Title 'Model 7 of Table 11.4, Period on Repeated Statement, No KR, also Box 5';
proc mixed data=standard covtest ratio ic ;
	class  trt post period school post;
	model msapperform = Trt Post Trt*Post  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/  s cl ;
	Repeated Period /sub= school(trt)type=ar(1) r rcorr ;
	weight impscore;
	parms /nobound;
run;

		/* This ends the code for Table 11.4*/
		/* The syntax in this file is copyright by Robert B. Smith,  2011 */











     









  


